/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import fi.dy.masa.litematica.render.schematic.ChunkRenderLayers;
import fi.dy.masa.litematica.render.schematic.ChunkRenderObjectBuffers;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;

public class GpuBufferCache
implements AutoCloseable {
    private final ConcurrentHashMap<ChunkSectionLayer, ChunkRenderObjectBuffers> blockBuffers = new ConcurrentHashMap();
    private final ConcurrentHashMap<RenderType, ChunkRenderObjectBuffers> layerBuffers = new ConcurrentHashMap();
    private final ConcurrentHashMap<OverlayRenderType, ChunkRenderObjectBuffers> overlayBuffers = new ConcurrentHashMap();

    protected GpuBufferCache() {
    }

    protected boolean hasBuffersByBlockLayer(ChunkSectionLayer layer) {
        return this.blockBuffers.containsKey(layer);
    }

    protected boolean hasBuffersByLayer(RenderType layer) {
        return this.layerBuffers.containsKey(layer);
    }

    protected boolean hasBuffersByType(OverlayRenderType type) {
        return this.overlayBuffers.containsKey((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeBuffersByBlockLayer(ChunkSectionLayer layer, @Nonnull ChunkRenderObjectBuffers newBuffer) {
        if (this.hasBuffersByBlockLayer(layer)) {
            ChunkRenderObjectBuffers remove = this.blockBuffers.remove(layer);
            try {
                remove.close();
            }
            catch (Exception err) {
                throw new RuntimeException("Exception closing Block Layer " + layer.label() + " Buffers; " + err.getMessage());
            }
        }
        ConcurrentHashMap<ChunkSectionLayer, ChunkRenderObjectBuffers> concurrentHashMap = this.blockBuffers;
        synchronized (concurrentHashMap) {
            this.blockBuffers.put(layer, newBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeBuffersByLayer(RenderType layer, @Nonnull ChunkRenderObjectBuffers newBuffer) {
        if (this.hasBuffersByLayer(layer)) {
            ChunkRenderObjectBuffers remove = this.layerBuffers.remove(layer);
            try {
                remove.close();
            }
            catch (Exception err) {
                throw new RuntimeException("Exception closing Layer " + ChunkRenderLayers.getFriendlyName(layer) + " Buffers; " + err.getMessage());
            }
        }
        ConcurrentHashMap<RenderType, ChunkRenderObjectBuffers> concurrentHashMap = this.layerBuffers;
        synchronized (concurrentHashMap) {
            this.layerBuffers.put(layer, newBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeBuffersByType(OverlayRenderType type, @Nonnull ChunkRenderObjectBuffers newBuffer) {
        if (this.hasBuffersByType(type)) {
            ChunkRenderObjectBuffers remove = this.overlayBuffers.remove((Object)type);
            try {
                remove.close();
            }
            catch (Exception err) {
                throw new RuntimeException("Exception closing Overlay Type " + type.name() + " Buffers; " + err.getMessage());
            }
        }
        ConcurrentHashMap<OverlayRenderType, ChunkRenderObjectBuffers> concurrentHashMap = this.overlayBuffers;
        synchronized (concurrentHashMap) {
            this.overlayBuffers.put(type, newBuffer);
        }
    }

    @Nullable
    protected ChunkRenderObjectBuffers getBuffersByBlockLayer(ChunkSectionLayer layer) {
        return this.blockBuffers.get(layer);
    }

    @Nullable
    protected ChunkRenderObjectBuffers getBuffersByLayer(RenderType layer) {
        return this.layerBuffers.get(layer);
    }

    @Nullable
    protected ChunkRenderObjectBuffers getBuffersByType(OverlayRenderType type) {
        return this.overlayBuffers.get((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAll() {
        ConcurrentHashMap<Object, ChunkRenderObjectBuffers> concurrentHashMap = this.blockBuffers;
        synchronized (concurrentHashMap) {
            this.blockBuffers.forEach((layer, buffers) -> {
                try {
                    buffers.close();
                }
                catch (Exception err) {
                    throw new RuntimeException("Exception closing Block Layer " + layer.label() + " Buffers; " + err.getMessage());
                }
            });
            this.blockBuffers.clear();
        }
        concurrentHashMap = this.layerBuffers;
        synchronized (concurrentHashMap) {
            this.layerBuffers.forEach((layer, buffers) -> {
                try {
                    buffers.close();
                }
                catch (Exception err) {
                    throw new RuntimeException("Exception closing Layer " + ChunkRenderLayers.getFriendlyName(layer) + " Buffers; " + err.getMessage());
                }
            });
            this.layerBuffers.clear();
        }
        concurrentHashMap = this.overlayBuffers;
        synchronized (concurrentHashMap) {
            this.overlayBuffers.forEach((type, buffers) -> {
                try {
                    buffers.close();
                }
                catch (Exception err) {
                    throw new RuntimeException("Exception closing Overlay Type " + type.name() + " Buffers; " + err.getMessage());
                }
            });
            this.overlayBuffers.clear();
        }
    }

    @Override
    public void close() throws Exception {
        this.clearAll();
    }
}

